/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.reload;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IReloader;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.animation.ReloadAnimation;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class FullReloader
implements IReloader {
    private IAnimationProvider animationProvider;
    private boolean reloading;
    private int ticksLeft;
    private GunItem gun;
    private ItemStack stack;

    public FullReloader() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.animationProvider = IAnimationProvider.DEFAULT_PROVIDER;
        });
    }

    public FullReloader(IAnimationProvider provider) {
        this.animationProvider = provider;
    }

    @Override
    public void initiateReload(PlayerEntity player, GunItem item, ItemStack _stack) {
        this.reloading = true;
        this.ticksLeft = item.getReloadTime(PlayerData.getUnsafe(player).getAttributes(), _stack);
        this.gun = item;
        this.stack = _stack;
        if (player.field_70170_p.field_72995_K) {
            this.playAnimation(player);
        }
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public void enqueueCancel() {
    }

    @Override
    public void forceCancel() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::cancelAnimations);
    }

    @Override
    public void tick(PlayerEntity player) {
        if (this.reloading && --this.ticksLeft <= 0) {
            this.reloading = false;
            this.onReload(player);
        }
    }

    private void onReload(PlayerEntity player) {
        if (!(this.gun instanceof GunItem)) {
            return;
        }
        IPlayerData data = PlayerData.getUnsafe(player);
        int weaponLimit = this.gun.getMaxAmmo(data.getAttributes());
        int currentAmmo = this.gun.getAmmo(this.stack);
        int toLoad = weaponLimit - currentAmmo;
        AmmoType ammoType = this.gun.getAmmoType();
        IAmmoMaterial material = this.gun.getMaterialFromNBT(this.stack);
        PlayerInventory inventory = player.field_71071_by;
        if (!player.func_184812_l_()) {
            boolean consumed;
            while ((consumed = ItemLocator.consume((IInventory)inventory, ItemLocator.filterByAmmoTypeAndMaterial(ammoType, material), ctx -> {
                int ammo = this.gun.getAmmo(this.stack);
                int remaining = weaponLimit - ammo;
                ItemStack stack = ctx.getCurrectStack();
                int count = stack.func_190916_E();
                int load = Math.min(remaining, count);
                stack.func_190918_g(load);
                this.gun.setAmmoCount(player.func_184614_ca(), ammo + load);
            })) && weaponLimit - this.gun.getAmmo(this.stack) > 0) {
            }
        } else {
            this.gun.setAmmoCount(player.func_184614_ca(), weaponLimit);
        }
        data.getHandState().freeHands();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playAnimation(PlayerEntity player) {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        ResourceLocation path = this.animationProvider.getReloadAnimationPath(this.gun, player);
        ReloadAnimation animation = AnimationUtils.createAnimation(path, provider -> new ReloadAnimation((IKeyframeProvider)provider, this.ticksLeft));
        pipeline.insert(ModAnimations.RELOAD, animation);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cancelAnimations() {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        pipeline.remove(ModAnimations.RELOAD);
    }

    @FunctionalInterface
    public static interface IAnimationProvider {
        public static final IAnimationProvider DEFAULT_PROVIDER = GunItem::getReloadAnimation;

        public ResourceLocation getReloadAnimationPath(GunItem var1, PlayerEntity var2);
    }
}

